--
-- script to generate STATSPACK collections
-- for every interval
--
-- this script also generates a capacity report
-- ensure capacity_11g.sql, capacity_12c.sql, splunk_capacity_11g.sql and splunk_capacity_12c.sql
-- are in the current directory
--
-- usage: gensprpt.sql [RANGE] - where range is the number of hours worth of data to collect
--
-- connect as any user with access to the Statspack tables, such as the PERFSTAT account.  

set echo off
set heading off
set feedback off
set pagesize 50000
set linesize 999
set verify off
set trimspool on

alter session set nls_date_language=american;

whenever sqlerror continue
whenever oserror continue

prompt
prompt
prompt
prompt Dell Statspack Collection Tool
prompt ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
prompt

--
-- get the range from the command line
-- or prompt the user for it
--

variable snaprange    number;

prompt Enter the Statspack snapshot range to collect in hours
define snap_range = '&1'

-- if no answer is given use 168 hours
begin

  select
    to_number(nvl('&snap_range',168))
  into :snaprange from dual;

end;
/

--
-- create a spool file
--

column ext     new_value new_ext
column dbname  new_value new_dbname

select name dbname, '.sql' ext from V$DATABASE;

spool sp_collect_&new_dbname&new_ext

select 'prompt collecting statspack data - this may take a while' from dual;
select 'set echo off'       from dual;
select 'set term off'       from dual;
select 'set heading off'    from dual;
select 'set feedback off'   from dual;
select 'set pagesize 50000' from dual;
select 'set linesize 999'   from dual;
select 'set trimspool on'   from dual;
select 'alter session set nls_date_language=american;' from dual;

--
-- add the statspack collection commands
--
with summary_t as (
  select
    dbid,
    snap_time,
    instance_number,
    snap_id,
    last_snap_id,
    startup_time,
    last_startup_time
  from (
    select
      snap.dbid,
      snap.instance_number,
      vd.name,
      snap.snap_time,
      snap.snap_id,
      lag(snap.snap_id,1)over(order by snap.instance_number,snap.snap_id) last_snap_id,
      snap.startup_time,
      lag(snap.startup_time,1)over(order by snap.instance_number,snap.snap_id) last_startup_time
    from
      perfstat.stats$snapshot snap,
      v$database vd
    where 1=1
    and snap.dbid = vd.dbid
    and snap_time > sysdate-(:snaprange/24)
    order by snap.snap_id  
    ) 
  where startup_time = last_startup_time
)
select
  'set term on'||chr(10)||
  'prompt collecting '||rownum||' of '||(select to_char(count(*)) from summary_t)||chr(10)||
  'set term off'||chr(10)||
  'define begin_snap='||last_snap_id||';'||chr(10)||
  'define end_snap='||snap_id||';'||chr(10)||
  'define report_name=sp_'||vi.instance_name||'_'||
    last_snap_id||'_'||snap_id||
    '.txt'||chr(10)||'@?/rdbms/admin/spreport;'||chr(10) "-- command"
from
  summary_t, v$instance vi
/

--
-- generate the capacity reports
--
select 'set term on' "-- command" from dual
union all
select 'prompt collecting capacity data' from dual
union all
select 'set term off' from dual
--
union all
--
select '@@capacity_12c.sql'||chr(10)||'@@capacity_splunk_12c.sql' "-- generate capacity report"
from v$instance
where regexp_substr( version, '[^.]*', 1, 1, 'i') not in ('10','11')
--
union all
--
select '@@capacity_11g.sql'||chr(10)||'@@capacity_splunk_11g.sql'
from v$instance
where regexp_substr( version, '[^.]*', 1, 1, 'i') in( '11' )
--
union all
--
select '@@capacity_10g.sql'||chr(10)||'@@capacity_splunk_10g.sql'
from v$instance
where regexp_substr( version, '[^.]*', 1, 1, 'i') in( '10' )
/

--
-- notify that report is complete
--
select 'set term on' from dual;
select 'prompt Statspack data collection complete' from dual;

spool off

prompt
--

prompt now execute the script sp_collect_&new_dbname&new_ext
prompt reports will be generated in the current directory
