# Invoke-IcingaCheckMSSQLResource

## Description

MSSQL plugin which checks for page life expectancy, buffer cache hit ratio',
average latch wait time (ms) Performance Counters

MSSQL plugin which checks for page life expectancy, buffer cache hit ratio',
average latch wait time (ms) Performance Counters
More Information on https://github.com/Icinga/icinga-powershell-mssql

## Permissions

No special permissions required.

## Arguments

| Argument | Type | Required | Default | Description |
| ---      | ---  | ---      | ---     | ---         |
| PageLifeExpectancyCritical | Object | false |  | Critical threshold for the page life expectancy which indicates the number of seconds a page will stay in the buffer pool without references. |
| PageLifeExpectancyWarning | Object | false |  | Warning threshold for the page life expectancy which indicates the number of seconds a page will stay in the buffer pool without references. |
| AverageLatchWaitTimeCritical | Object | false |  | Critical threshold for the Average Latch Wait Time (ms) for latch requests that had to wait. |
| AverageLatchWaitTimeWarning | Object | false |  | Warning threshold for the Average Latch Wait Time (ms) for latch requests that had to wait. |
| BufferCacheHitRatioCritical | Object | false |  | Warning threshold for the Buffer cache hit ratio which Indicates the percentage of pages found in the buffer cache without having to read from disk.<br /> The ratio is the total number of cache hits divided by the total number of cache lookups over the last few thousand page accesses. After a long period<br /> of time, the ratio moves very little. Because reading from the cache is much less expensive than reading from disk, you want this ratio to be high.<br /> Generally, you can increase the buffer cache hit ratio by increasing the amount of memory available to SQL Server or by using the buffer pool extension<br /> feature. |
| BufferCacheHitRatioWarning | Object | false |  | Warning threshold for the Buffer cache hit ratio which Indicates the percentage of pages found in the buffer cache without having to read from disk.<br /> The ratio is the total number of cache hits divided by the total number of cache lookups over the last few thousand page accesses. After a long period<br /> of time, the ratio moves very little. Because reading from the cache is much less expensive than reading from disk, you want this ratio to be high.<br /> Generally, you can increase the buffer cache hit ratio by increasing the amount of memory available to SQL Server or by using the buffer pool extension<br /> feature. |
| SqlUsername | String | false |  | The username for connecting to the MSSQL database |
| SqlPassword | SecureString | false |  | The password for connecting to the MSSQL database as secure string |
| SqlHost | String | false | localhost | The IP address or FQDN to the MSSQL server to connect to |
| SqlPort | Int32 | false | 1433 | The port of the MSSQL server/instance to connect to with the provided credentials |
| SqlDatabase | String | false |  | The name of a specific database to connect to. Leave empty to connect "globally" |
| IntegratedSecurity | SwitchParameter | false | False | Allows this plugin to use the credentials of the current PowerShell session inherited by<br /> the user the PowerShell is running with. If this is set and the user the PowerShell is<br /> running with can access to the MSSQL database you will not require to provide username<br /> and password |
| NoPerfData | SwitchParameter | false | False | Disables the performance data output of this plugin |
| Verbosity | Int32 | false | 0 | Changes the behavior of the plugin output which check states are printed:<br /> 0 (default): Only service checks/packages with state not OK will be printed<br /> 1: Only services with not OK will be printed including OK checks of affected check packages including Package config<br /> 2: Everything will be printed regardless of the check state<br /> 3: Identical to Verbose 2, but prints in addition the check package configuration e.g (All must be [OK])e |
| ThresholdInterval | String |  |  | Change the value your defined threshold checks against from the current value to a collected time threshold of the Icinga for Windows daemon, as described [here](https://icinga.com/docs/icinga-for-windows/latest/doc/110-Installation/06-Collect-Metrics-over-Time/). An example for this argument would be 1m or 15m which will use the average of 1m or 15m for monitoring. |

## Examples

### Example Command 1

```powershell
Invoke-IcingaCheckMSSQLResource -SqlUsername 'username' -SqlPassword (ConvertTo-IcingaSecureString 'password') -SqlHost 'example.com' -Verbosity 3;
```

### Example Output 1

```powershell
[OK] MSSQL Performance (MSSQLSERVER) (All must be [OK])
\_ [OK] SQLServer:Buffer Manager (All must be [OK])
    \_ [OK] Buffer cache hit ratio: 100%
    \_ [OK] Page life expectancy: 1772
\_ [OK] SQLServer:Latches (All must be [OK])
    \_ [OK] Average Latch Wait Time (ms): 0.001515s
| sqlserverbuffermanager::ifw_mssqlresource::buffercachehitratio=100%;;;0;100 sqlserverbuffermanager::ifw_mssqlresource::pagelifeexpectancy=1772;;;; sqlserverlatches::ifw_mssqlresource::averagelatchwaittimems=0.001515s;;;;    
```

### Example Command 2

```powershell
Invoke-IcingaCheckMSSQLResource -IntegratedSecurity -SqlHost 'example.com' -Verbosity 3;
```

### Example Output 2

```powershell
[OK] MSSQL Performance (MSSQLSERVER) (All must be [OK])
\_ [OK] SQLServer:Buffer Manager (All must be [OK])
    \_ [OK] Buffer cache hit ratio: 100%
    \_ [OK] Page life expectancy: 1772
\_ [OK] SQLServer:Latches (All must be [OK])
    \_ [OK] Average Latch Wait Time (ms): 0.001515s
| sqlserverbuffermanager::ifw_mssqlresource::buffercachehitratio=100%;;;0;100 sqlserverbuffermanager::ifw_mssqlresource::pagelifeexpectancy=1772;;;; sqlserverlatches::ifw_mssqlresource::averagelatchwaittimems=0.001515s;;;;    
```


