# Icinga Knowledge Base - IWKB000011

## Short Message

[SC] ChangeServiceConfig FAILED 1072: The specified service has been marked for deletion

## Reason

While updating the Icinga Agent, the above error message can occur during the upgrade process. This is caused as the Icinga Agent installer is not allowing an upgrade over CLI, but requires an uninstallation before.
Even when updating the Icinga Agent by the GUI version of the MSI installer, an upgrade will always remove the Icinga Agent service from the system, installing it later again.

Because of several possible remaining access from the current PowerShell, a Task Manager view, an open Service view or other reasons, the service is not being deleted right away, but marked for deletion instead. This prevents the Icinga Agent installer to install the new service, as the old one is still present.

## Solution

To resolve this issue, you will have to close all PowerShell instances, the Task Manager and the Service view in case open. Once closed, you can repair the Icinga Agent service with the following command:

```powershell
Repair-IcingaService;
```

This will check if the Icinga Agent is installed on a default location and install the service again.

In case you have installed the Icinga Agent inside a different folder, you can provide the Icinga Agent root folder with the argument `-RootFolder`:

```powershell
Repair-IcingaService -RootFolder 'D:\Programs\ICINGA2';
```
