Developer Guide for Custom Plugins
===

This PowerShell Framework provides a wide collection of Cmdlets and Tools to allow an easy extension and developing of custom Check Plugins for Icinga.

To ensure the overall functionality of the framework is supported by your custom Plugins, we would advice you to cover all topics of this Developer guide.

Functions
---

A detailed overview of functions can be found below

* [New-IcingaCheck](developerguide/01-New-IcingaCheck.md)
* [New-IcingaCheckPackage](developerguide/02-New-IcingaCheckPackage.md)
* [New-IcingaCheckResult](developerguide/03-New-IcingaCheckResult.md)

General Handling
---

There are some general guidelines, functions and toolsets available making the development in general easier. Here you can find a list of topics

* [Cim-Instance/Wmi-Object fetching](developerguide/50-Fetching-Cim_and_Wmi_Data.md)
* [Working with Performance Counters](developerguide/51-Working-with-Performance-Counters.md)
* [Testing of Commands](developerguide/52-Testing-of-Commands.md)

Example Usage
---

To get started easier you can find detailed examples for developing modules/integrations/best practices in the following categories:

* [Custom Daemons](developerguide/10-Custom-Daemons.md)
* [Custom Plugins](developerguide/11-Custom-Plugins.md)
* [Custom API-Endpoints](developerguide/12-Custom-API-Endpoints.md)
* [Using Console Outputs](developerguide/20-Using-Console-Outputs.md)
* [Using EventLog Output](developerguide/21-Using-EventLog-Outputs.md)
