# Icinga Knowledge Base - IWKB000009

## Short Message

Security Scanner: The remote Windows host has at least one service installed that uses an unquoted service path, which contains at least one whitespace. A local attacker can gain elevated privileges by inserting an executable file in the path of the affected service

## Reason

The path pointing to the `icinga-service.exe` is not encapsulated inside double quotes `"` during creation. This might open a possible vulnerability and provide a possible attack vector for attackers gaining access to the machine. In worst case, attackers can place a binary file on the location of the path where the whitespace stops. This binary is then executed with the privileges the service is running with, which could cause a security issue.

You can read this [blogpost](http://www.ryanandjeffshow.com/blog/2013/04/05/the-microsoft-windows-unquoted-service-path-vulnerability/) by Jeff Liford to get a better idea on the problem.

## Solution

This is directly fixed within Icinga for Windows v1.3.2, 1.4.2, v1.5.2 and 1.6.0 during the service creation. If you created the service starting with one of these versions, you are not affected.

If not, please update your environment to a version which includes the fix and start a new PowerShell. Afterwards use this code snippet to re-create the service with all your configuration:

```powershell
Use-Icinga;
$IcingaService = Get-CimInstance Win32_Service `
    | Where-Object {
            $_.Name -eq 'icingapowershell'
        } `
    | Select-Object Name, StartName, PathName;

if ($null -ne $IcingaService) {
    $IfWUser = $IcingaService.StartName;
    $IfWPath = $IcingaService.PathName.SubString(0, $IcingaService.PathName.IndexOf(' "'));

    if ($IfWPath[0] -eq '"' -And $IfWPath[-1] -eq '"') {
        return;
    }

    Uninstall-IcingaFrameworkService;
    Install-IcingaFrameworkService -Path $IfWPath -User $IfWUser;
}
```

## Test Vulnerability

If you want to test if the above fix work or if you are affected by this problem, you can run this script:

```powershell
$IcingaService = Get-CimInstance Win32_Service `
    | Where-Object {
            $_.Name -eq 'icingapowershell'
        } `
    | Select-Object Name, StartName, PathName;

$IfWPath = $IcingaService.PathName.SubString(0, $IcingaService.PathName.IndexOf(' "'));

if ($IfWPath.Contains('"')) {
    Write-Host -ForegroundColor Green 'Your service installation is secure';
} else {
    Write-Host -ForegroundColor Red 'You are possibly affected by a whitespace service vulnerability';
}
```
