# Icinga Knowledge Base - IWKB000005

## Short Message

powershell.exe : Failed to start service 'Icinga PowerShell Service (icingapowershell)'.

## Example Exception

powershell.exe : Failed to start service 'Icinga PowerShell Service (icingapowershell)'.

At C:\Program
Files\WindowsPowerShell\Modules\icinga-powershell-framework\lib\core\framework\Restart-IcingaService.psm1:29 char:9

\+         powershell.exe -Command {

\+         ~~~~~~~~~~~~~~~~~~~~~~~~~

\+ CategoryInfo          : OpenError: (System.ServiceProcess ServiceController:ServiceController) [Restart-Service], ServiceCommandException

\+ FullyQualifiedErrorId :
StartServiceFailed,Microsoft.PowerShell.Commands.RestartServiceCommand

### Event Log Entry

error-event (Source: Icinga
PowerShell Service, Event ID 0):

Service cannot be started. System.ComponentModel.Win32Exception
(0x80004005): The system cannot find the file specified

at System.Diagnostics.Process.StartWithCreateProcess(ProcessStartInfo
startInfo)

at icinga_service.src.classes.Agent.StartAgent()

at System.ServiceProcess.ServiceBase.ServiceQueuedMainCallback(Object
state)

## Reason

The `icingapowershell` service of the `Icinga for Windows` solution is unable to locate `powershell.exe`. The service is using `powershell.exe` natively without any directory configuration and looking up the `PATH` variable which normally includes a path like `C:\Windows\System32\WindowsPowerShell\v1.0` which contains the required `powershell.exe`

## Solution

### With PowerShell

To resolve this issue, ensure that your `PATH` environment variable is containing a directory which inherits a `powershell.exe`. By default, this should be `C:\Windows\System32\WindowsPowerShell\v1.0`.

You can check this by opening a PowerShell by running the following command:

```powershell
($ENV:Path).Split(';')
```

If there is no directory listed containing a `powershell.exe`, you will have to add this path manually. You can either use the UI for this or modify and run the following PowerShell code within an Administrator shell to add a new path permanently to the `PATH` variable by modifying the registry:

```powershell
# The variable containing the folder we want to include
$PathDir = 'please enter the path here';

# Read PATH from registry
$CurrentPath = (Get-ItemProperty `
    -Path 'HKLM:\System\CurrentControlSet\Control\Session Manager\Environment' `
    -Name 'PATH'
).path;

# Add our defined path to the CurrentPath variable
$CurrentPath = [string]::Format('{0};{1}', $CurrentPath, $PathDir);

# Write the modified Path into the registry
Set-ItemProperty `
    -Path 'HKLM:\System\CurrentControlSet\Control\Session Manager\Environment' `
    -Name 'PATH' `
    -Value $CurrentPath;
```

Now open a new PowerShell session again and check of the new directory was added:

```powershell
($ENV:Path).Split(';')
```

Once the directory is there, restart the `icingapowershell` service by running

```powershell
Restart-Service 'icingapowershell'
```

Now the error should be resolved the the service should be running.

### With UI

You can use the UI for modifying the `PATH` variable. Please follow the steps below

* Click on `Windows/Start` with the right mouse button
* Click on `System`
* In the new windows click in `Advanced System Settings` (on Windows 2012 R2 or older on the left side, on Windows 2016 or newer on the right side)
* Click on the `Advanced` tab
* Click on `Environment Variables`
* In the section `System variables` locate the entry `Path` and double click or simply left click to select it and then click the `Edit` button

Windows 2012 R2 or older:

* Jump to the end of the textbox `Value of Variable` (containing different directories) and add a `;` if not already present. Afterwards add the path containing your `powershell.exe`, like `C:\Windows\System32\WindowsPowerShell\v1.0`
* Close all windows by clicking on `OK`

Windows 2016 or newer

* Click the `New` button on the top-right of the new window
* Add the path containing your `powershell.exe`, like `C:\Windows\System32\WindowsPowerShell\v1.0` on the newly created entry
* Close all windows by clicking on `OK`

Now open a new PowerShell session again and check of the new directory was added:

```powershell
($ENV:Path).Split(';')
```

Once the directory is there, restart the `icingapowershell` service by running

```powershell
Restart-Service 'icingapowershell'
```

Now the error should be resolved the the service should be running.
