# Icinga Knowledge Base - IWKB000019

## Short Message

Icinga Invalid Input Error was thrown: RegexError

## Example Exception

Icinga Invalid Input Error was thrown: RegexError

A request was not handled properly because a provided regex could not be interpreted. Please validate your regex and try again. In case you are trying to access a ressource containing [], you will have to escape each symbol by using \`. Example: myservice\`[\`]

## Reason

Icinga for Windows itself and most PowerShell Cmdlets will support to add regex expressions, like simple wildcards (`*`) or other terms into arguments for like `Path` or `Name`. Because of this behavior, a bracket `[]` will in some cases be interpreted as regex, but because of an invalid format, causing errors like the one above. This mostly happens in case you have service names or directories/files, containing such characters.

## Solution

While the directory check plugin for Icinga for Windows does the escaping in such cases automatically starting with version 1.13.0, because by providing a path regex is not really a concern for the plugin, there is a different story for examples like the service plugin.

In case you have a service called `mycustomservice[]`, you will run into the exception above. To mitigate this, you have to escape brackets with the backticks.

```powershell
Invoke-IcingaCheckService -Service 'mycustomservice`[`]';
```

Now your checks will run through as expected without any issues.
