# Icinga Knowledge Base - IWKB000018

## Short Message

Icinga for Windows services throws event id 1500 with error `Exception while calling AuthenticateAsServer: The credentials supplied to the package were not recognized`

## Example Exception

Icinga for Windows throws an error with event id 1500:

```
Failed to securely establish a communication between this server and the client

A client connection could not be established to this server. This issue is mostly caused by using Self-Signed/Icinga 2 Agent certificates for the server and the client not trusting the certificate. To resolve this issue, either use trusted certificates signed by your trusted CA or setup the client to accept untrusted certificates

Icinga for Windows exception report:

Exception Message:
Exception calling "AuthenticateAsServer" with "4" argument(s): "The credentials supplied to the package were not recognized"

Command Origin:
Internal

...
```

## Reason

This message happens in case the user assigned to run the Icinga for Windows has no sufficient permissions to access the `icingaforwindows.pfx` certificate file or has no permissions to read the private key from the certificate file.

## Solution

To resolve this issue, you will either have to use [JEA-Profiles](../130-JEA/01-JEA-Profiles.md) or use a different user having enough permissions to access private key to the file. In general, only `LocalSystem` or `Administrators` have access to this key, which is why we highly recommend the use of JEA.
